/* global sc, sca, cx */
let $$ = require('cdev/debug')({ debug: true, path: module.id, prefix: '[isg.xpert.archive]' });
$$.objects = require('common/objects');

// default display options
let showTitle = true; // overwritten by widget.showTitle

let metadata = require('common/metadata');
let aguila = require('common/aguila');

let utils = require('../idx-utils');

// load acic filter settings from metadata-collection
let filterLib = require('/agorum/roi/customers/agorum.metadata.collection/js/acic/filter');
let config = filterLib.get('isg_xpert_archive_DocumentAcicFilterExplorer');

// cleanup filter configuration
let baseQuery = config.baseQuery; // save original query
delete config.type;
delete config.name;
delete config.text;
config.baseQuery = 'id:0'; // dummy with null result
config.listConfig = 'isg_xpert_archive_acicArchiveView';

// basic information center widget
let aon = require('./acic-archive-view-aon.js');
// $$.debug(Object.assign(aon, config));

let widget = aguila.create(Object.assign(aon, config));

setImmediate(() => {
  $$.debug('widget.properties', widget.properties);
  $$.debug('widget.order', widget.order);
  $$.debug('widget.record', widget.record);
  $$.debug('widget.id', widget.id);

  // widget.form.header = 'Header';
  // widget.form.title = 'Title';

  /** DEBUGGING **
  // widget.id = 'N263288018';
  // widget.order = 'A-10829161';
  // widget.record = '8011695';
  /**/

  // first, check for order number and load order document data
  if (widget.order) {
    $$.debug('checking widget.order', widget.order);
    let order = $$.objects
      .query(
        'inpath:${FOLDERPATH:/agorum/roi/Files} area:mdb area:archive area:records classname:fileobject isg_xpert_archive_insnumber:* isg_xpert_archive_ordernumber:' +
          widget.order
      )
      .limit(1)
      .find()[0];
    // if (!order) throw new Error('order [{0}] not found'.format(widget.order));
    if (!order)
      throw new Error(
        'Für diese Auftragsnummer [{0}] sind noch keine Dokumente im Archiv vorhanden!'.format(widget.order)
      );
    let meta = metadata().load(order, /^isg/).data();
    widget.id = meta.isg_xpert_archive_insNumber;
  }

  // second, check for insurance number and load insurance record data
  if (widget.record) {
    let record = $$.objects.tryFind(widget.record);
    $$.debug('using widget.record', widget.record, record);
    if (!record) throw new Error('Patentientakte [{0}] nicht im Archiv gefunden!'.format(widget.record));
    let meta = metadata().load(record, /^isg/).data();
    widget.id = meta.isg_xpert_archive_insNumber;
  }

  // finally, check for insurance number and load insurance record data
  if (widget.id) {
    $$.debug('using widget.id', widget.id);
    let record = $$.objects
      .query(
        'inpath:${FOLDERPATH:/agorum/roi/Files} area:mdb area:archive area:records classname:folderobject isg_xpert_archive_insnumber:' +
          widget.id
      )
      .limit(1)
      .find()[0];
    // if (!record) throw new Error('id [{0}] not found'.format(widget.id));
    if (!record)
      throw new Error('Für diesen Versicherten [{0}] sind noch keine Dokumente im Archiv vorhanden!'.format(widget.id));
    let meta = metadata().load(record, /^isg/).data();

    let title = '{0} - {1} - {2}'.format(
      meta.isg_xpert_archive_insNumber,
      meta.isg_xpert_archive_insName,
      utils.dateToString(meta.isg_xpert_archive_insBirthday)
    );
    showTitle = widget.showTitle || showTitle;
    if (widget.external && showTitle) widget.title = title;
    widget.form.title = title;
  }

  widget.baseQuery = baseQuery + ' isg_xpert_archive_insnumber:' + widget.id;
  widget.selection = $$.objects.query(widget.baseQuery).sort('createdate desc').limit(1).find();
});

widget;
